#ifdef _MSC_VER
#   pragma warning( disable : 4702 ) //unreachable code in STL for VC71
#endif
#include <log4cpp/LayoutsFactory.hh>
#include <stdexcept>

LOG4CPP_NS_BEGIN
static LayoutsFactory* layouts_factory_ = 0;

std::auto_ptr<Layout> create_simple_layout(const FactoryParams& params);
std::auto_ptr<Layout> create_basic_layout(const FactoryParams& params);
std::auto_ptr<Layout> create_pattern_layout(const FactoryParams& params);
std::auto_ptr<Layout> create_pattern_layout(const FactoryParams& params);
std::auto_ptr<Layout> create_pass_through_layout(const FactoryParams& params);

LayoutsFactory& LayoutsFactory::getInstance()
{
    if (!layouts_factory_)
    {
        std::auto_ptr<LayoutsFactory> lf(new LayoutsFactory);
        lf->registerCreator("simple", &create_simple_layout);
        lf->registerCreator("basic", &create_basic_layout);
        lf->registerCreator("pattern", &create_pattern_layout);
        lf->registerCreator("pass through", &create_pass_through_layout);
        layouts_factory_ = lf.release();
    }

    return *layouts_factory_;
}

void LayoutsFactory::registerCreator(const std::string& class_name, create_function_t create_function)
{
    const_iterator i = creators_.find(class_name);
    if (i != creators_.end())
        throw std::invalid_argument("Layout creator for type name '" + class_name + "' already registered");
        //throw INVALID_ARGUMENT_EXCEPTION("Layout creator for type name '%s' already registered", class_name.c_str());

    creators_[class_name] = create_function;
}

std::auto_ptr<Layout> LayoutsFactory::create(const std::string& class_name, const params_t& params)
{
    const_iterator i = creators_.find(class_name);
    if (i == creators_.end())
        throw std::invalid_argument("There is no layout with type name '" + class_name + "'");
        //throw INVALID_ARGUMENT_EXCEPTION("There is no layout with type name '%s'", class_name.c_str());

    return (*i->second)(params);
}

bool LayoutsFactory::registed(const std::string& class_name) const
{
    return creators_.find(class_name) != creators_.end();
}
LOG4CPP_NS_END

