
#include <log4cpp/CategoryAdapter.hh>


LOG4CPP_NS_BEGIN

CategoryAdapter::CategoryAdapter(LOG4CPP_NS::Category& categoryRef) :
  mCategoryRef(categoryRef)
{

}

CategoryAdapter::~CategoryAdapter()
{

}

void CategoryAdapter::Log(ILogger::Priority logPriority, const char* stringFormat, ...)
{
  try
  {
    va_list va;
    va_start(va, stringFormat);
    mCategoryRef.logva(GetPriority(logPriority), stringFormat, va);
    va_end(va);
  }
  catch (const std::exception &ex)
  {
      mCategoryRef.warn( ex.what() );
  }
  catch (...)
  {
      mCategoryRef.warn( "Failed to log message. Unknown exception." );
  }
}

void CategoryAdapter::LogVA(ILogger::Priority logPriority, const char* stringFormat, va_list arg)
{
  try
  {
    mCategoryRef.logva(GetPriority(logPriority), stringFormat, arg);
  }
  catch (const std::exception &ex)
  {
    mCategoryRef.warn( ex.what() );
  }
  catch (...)
  {
    mCategoryRef.warn( "Failed to log message. Unknown exception." );
  }
}

LOG4CPP_NS::Priority::Value CategoryAdapter::GetPriority(ILogger::Priority gcPriority)
{
    LOG4CPP_NS::Priority::Value mappedPriority = LOG4CPP_NS::Priority::NOTSET;
    if (gcPriority <= ILogger::ERR)
    {
        mappedPriority = LOG4CPP_NS::Priority::ERROR;
    } 
    else if (gcPriority <= ILogger::WARN)
    {
        mappedPriority = LOG4CPP_NS::Priority::WARN;
    }
    else if (gcPriority <= ILogger::INFO)
    {
        mappedPriority = LOG4CPP_NS::Priority::INFO;
    }
    else if (gcPriority <= ILogger::DEBUG)
    {
        mappedPriority = LOG4CPP_NS::Priority::DEBUG;
    }

    return mappedPriority;
}

LOG4CPP_NS_END
