#include <log4cpp/Wrapper.hh>
#include <log4cpp/FileAppender.hh>

LOG4CPP_NS_BEGIN

PatternLayout* CreatePatternLayoutObject()
{
    // Instantiate a PatternLayout object and returns its pointer.
    return new PatternLayout();
}

void DestroyPatternLayoutObject(PatternLayout* object)
{
    // Destruct an object which is pointed by object.
    delete object;
}

#if defined (_WIN32)
Appender* CreateWin32DebugAppenderObject(const std::string& name)
{
    // Instantiate a PatternLayout object and returns its pointer.
    return new Win32DebugAppender(name);
}
#endif

Appender *CreateFileAppenderObject(const std::string& name, const std::string& fileName, bool append, mode_t mode)
{
    return new FileAppender(name, fileName, append, mode);
}

const LOG4CPP_NS::wrapper_t Wrapper = {
    // Initilaize the function table of Category class.
    {
        Category::getInstance,
        Category::getCurrentCategories,
        Category::exists,
        Category::getRoot,
        Category::shutdown,
        &Category::logva,
        &Category::isInfoEnabled,
        &Category::isWarnEnabled,
        &Category::isDebugEnabled,
        &Category::setPriority,
        &Category::addAppender,
        &Category::removeAppender
    },
    // Initilaize the function table of PatternLayout class. 
    {
        CreatePatternLayoutObject,
        &PatternLayout::setConversionPattern,
        DestroyPatternLayoutObject,
    },
    // Initilaize the function table of PropertyConfigurator class. 
    {
        PropertyConfigurator::configure,
    },
    // Initilaize the function table of NDC class. 
    {
        NDC::push,
        NDC::pop,
    },
#if defined (_WIN32)
    // Initilaize the function table of Win32DebugAppender class.
    {
        CreateWin32DebugAppenderObject,
    },
#endif
    // Initialize the function table for the Appender class.
    {
        CreateFileAppenderObject,
        &Appender::setThreshold,
        &Appender::setLayout
    }
};

LOG4CPP_NS_END
